import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample01_OnlineOrder_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .styleBold(true)
                .actionPrintText("${store_name}\n" + "${order_number}\n"),
            )
            .actionPrintText("${name}\n")
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.3),
            )
            .actionFeed(1.0)
            .actionPrintText(
              "${date}",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "${time}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeed(1.0)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintText("PICKUP ${pickup_time}\n")
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionFeedLine(1)
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .styleBold(true)
                .actionPrintText("${item_list.quantity} x ${item_list.name}\n")
                .styleBold(false)
                .actionPrintText("${item_list.detail}")
                .actionFeedLine(1),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionFeed(1.0)
            .actionPrintText("${note}\n")
            .actionFeed(1.0)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText(
              "${footer1}",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "${footer2}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "Star Online",
    "order_number" : "878289422",
    "name" : "John Smith",
    "date" : "October 6, 2020",
    "time" : "9:46:32 AM",
    "pickup_time" : "10:00 AM",
    "item_list" : [
        {
            "name" : "Chai",
            "quantity" : 1,
            "detail" : "    16 oz\\n    Whole\\n"
        },
        {
            "name" : "Tea",
            "quantity" : 1,
            "detail" : "    Star Tea(Black)\\n    Tee Bag in Beverage\\n    Whole\\n"
        }
    ],
    "note" : "Any black tea is fine if there's no Star tea. Thanks!",
    "footer1" : "LxO8",
    "footer2" : "Inman Register 2"
}`,
    );
  }
}
